import { IncomingMessage, ServerResponse } from 'node:http';

import { CognitoUserSession } from 'amazon-cognito-identity-js';
import { processUserSessionCookies } from 'controllers/helpers/processUserSessionCookies';
import { RequestHandlerOptions } from 'types';

import { HttpStatusCode } from 'consts/HttpStatusCode';

import { sendResJson } from 'lib/response/sendResJson/sendResJson';

export async function processUserSession(
    session: CognitoUserSession,
    req: IncomingMessage,
    res: ServerResponse,
    { logger }: RequestHandlerOptions,
) {
    processUserSessionCookies(session, res, { logger });

    sendResJson(res, HttpStatusCode.OK, {
        code: HttpStatusCode.OK,
        data: {
            id: session.getIdToken().getJwtToken(),
            access: session.getAccessToken().getJwtToken(),
            refresh: session.getRefreshToken().getToken(),
        },
    });
}
