import { ServerResponse } from 'node:http';

import { CognitoUserSession } from 'amazon-cognito-identity-js';
import cookie from 'cookie';
import { RequestHandlerOptions } from 'types';

import { DM_DOMAIN, DM_SECURE_COOKIE, ID_TOKEN_COOKIE_NAME, REFRESH_TOKEN_COOKIE_NAME } from 'consts/consts';

const SECOND = 1000;
// eslint-disable-next-line @typescript-eslint/no-magic-numbers
const DAY = 24 * 60 * 60 * SECOND;
// eslint-disable-next-line @typescript-eslint/no-magic-numbers
const REFRESH_TOKEN_TTL = 30 * DAY;

export function processUserSessionCookies(
    session: CognitoUserSession,
    res: ServerResponse,
    { logger }: RequestHandlerOptions,
) {
    res.setHeader('set-cookie', [
        cookie.serialize(ID_TOKEN_COOKIE_NAME, session.getIdToken().getJwtToken(), {
            expires: new Date(session.getIdToken().getExpiration() * SECOND),
            domain: DM_DOMAIN,
            path: '/',
            httpOnly: true,
            secure: DM_SECURE_COOKIE,
        }),
        cookie.serialize(REFRESH_TOKEN_COOKIE_NAME, session.getRefreshToken().getToken(), {
            expires: new Date(session.getIdToken().getIssuedAt() * SECOND + REFRESH_TOKEN_TTL),
            domain: DM_DOMAIN,
            path: '/',
            httpOnly: true,
            secure: DM_SECURE_COOKIE,
        }),
    ]);
}
