import { readFile } from 'node:fs/promises';
import { join } from 'node:path';

export type TemplateName = 'auth' | 'registration' | 'restore' | 'profile' | 'error404' | 'error500';

const TEMPLATES: Record<TemplateName, Promise<string>> = {
    auth: readTemplate('auth.html'),
    registration: readTemplate('registration.html'),
    restore: readTemplate('restore.html'),
    profile: readTemplate('profile.html'),
    error404: readTemplate('error404.html'),
    error500: readTemplate('error500.html'),
};

async function readTemplate(name: string): Promise<string> {
    return readFile(join(__dirname, '..', '..', '..', 'templates', name), 'utf-8');
}

export async function template(name: TemplateName): Promise<string> {
    return TEMPLATES[name];
}
