import { IncomingMessage, ServerResponse } from 'node:http';

import cookie from 'cookie';
import { RequestHandlerOptions } from 'types';

import { DM_DOMAIN, DM_SECURE_COOKIE, ID_TOKEN_COOKIE_NAME, REFRESH_TOKEN_COOKIE_NAME } from 'consts/consts';
import { HttpStatusCode } from 'consts/HttpStatusCode';

import { sendResJson } from 'lib/response/sendResJson/sendResJson';

export async function logoutController(
    req: IncomingMessage,
    res: ServerResponse,
    { logger }: RequestHandlerOptions,
): Promise<void> {
    const expires = new Date(0);

    res.setHeader('set-cookie', [
        cookie.serialize(ID_TOKEN_COOKIE_NAME, '', {
            expires,
            domain: DM_DOMAIN,
            path: '/',
            httpOnly: true,
            secure: DM_SECURE_COOKIE,
        }),
        cookie.serialize(REFRESH_TOKEN_COOKIE_NAME, '', {
            expires,
            domain: DM_DOMAIN,
            path: '/',
            httpOnly: true,
            secure: DM_SECURE_COOKIE,
        }),
    ]);

    sendResJson(res, HttpStatusCode.OK, {
        code: HttpStatusCode.OK,
    });
}
