import { IncomingMessage, ServerResponse } from 'node:http';

import { template } from 'controllers/helpers/template';
import escapeHTML from 'escape-html';
import { CurrentUserSchema, RequestHandlerOptions } from 'types';

import { HttpStatusCode } from 'consts/HttpStatusCode';

import { getCSP } from 'lib/csp/getCSP';
import { sendResHtml } from 'lib/response/sendResHtml/sendResHtml';
import { sendResRedirect } from 'lib/response/sendResRedirect/sendResRedirect';
import { setResNoCacheHeaders } from 'lib/response/setResNoCacheHeaders/setResNoCacheHeaders';
import { setResSecurityHeaders } from 'lib/response/setResSecurityHeaders/setResSecurityHeaders';

export async function profilePageController(
    currentUser: CurrentUserSchema | undefined,
    req: IncomingMessage,
    res: ServerResponse,
    { logger }: RequestHandlerOptions,
): Promise<void> {
    if (!currentUser) {
        return sendResRedirect(res, '/auth');
    }

    const templateStr = await template('profile');
    const content = templateStr.replace('{{email}}', escapeHTML(currentUser.email));

    const csp = getCSP();

    setResSecurityHeaders(res, csp, false);
    setResNoCacheHeaders(res);

    sendResHtml(res, HttpStatusCode.OK, content);
}
