import { IncomingMessage, ServerResponse } from 'node:http';

import { processIdToken } from 'controllers/helpers/processIdToken';
import { RequestHandlerOptions } from 'types';

import { HttpStatusCode } from 'consts/HttpStatusCode';

import { sendResJson } from 'lib/response/sendResJson/sendResJson';

export async function userController(
    req: IncomingMessage,
    res: ServerResponse,
    { logger }: RequestHandlerOptions,
): Promise<void> {
    const payload = await processIdToken(req, res, { logger });

    if (!payload) {
        return sendResJson(res, HttpStatusCode.UNAUTHORIZED, {
            code: HttpStatusCode.UNAUTHORIZED,
            error: {
                _: 'Invalid id token',
            },
        });
    }

    return sendResJson(res, HttpStatusCode.OK, {
        code: HttpStatusCode.OK,
        data: payload,
    });
}
