import { CSPField } from 'lib/csp/CSPField';

export class CSP {
    constructor(private readonly fields: Record<string, CSPField> = {}) {
        this.fields = fields;
    }

    field(name: string, postfix?: string | null): CSPField {
        if (!this.fields[name]) {
            this.fields[name] = new CSPField(name, postfix);
        }

        return this.fields[name]!;
    }

    default(): CSPField {
        return this.field('default');
    }

    script(): CSPField {
        return this.field('script');
    }

    img(): CSPField {
        return this.field('img');
    }

    media(): CSPField {
        return this.field('media');
    }

    object(): CSPField {
        return this.field('object');
    }

    font(): CSPField {
        return this.field('font');
    }

    frame(): CSPField {
        return this.field('frame');
    }

    frameAncestors(): CSPField {
        return this.field('frame-ancestors', null);
    }

    child(): CSPField {
        return this.field('child');
    }

    style(): CSPField {
        return this.field('style');
    }

    connect(): CSPField {
        return this.field('connect');
    }

    prefetch(): CSPField {
        return this.field('prefetch');
    }

    reportURI(): CSPField {
        return this.field('report', 'uri');
    }

    baseURI(): CSPField {
        return this.field('base', 'uri');
    }

    toString() {
        return Object.keys(this.fields)
            .map((fieldKey) => {
                return this.fields[fieldKey]!.toString();
            })
            .join('; ');
    }
}
