export class CSPField {
    private field: string;

    private postfix: string | null;

    private values: string[];

    constructor(field: string, postfix: string | null = 'src') {
        this.field = field;
        this.postfix = postfix;
        this.values = [];
    }

    add(value: string, after?: string): this {
        if (!this.values.includes(value)) {
            if (after) {
                this.values.splice(this.values.indexOf(after) + 1, 0, value);
            } else {
                this.values.push(value);
            }
        }

        return this;
    }

    any(): this {
        this.values = [];

        return this.add('*');
    }

    self(): this {
        return this.add("'self'");
    }

    none(): this {
        return this.add("'none'");
    }

    unsafeInline(): this {
        return this.add("'unsafe-inline'");
    }

    unsafeEval(): this {
        return this.add("'unsafe-eval'");
    }

    data(): this {
        return this.add('data:');
    }

    blob(): this {
        return this.add('blob:');
    }

    url(url: string, after?: string): this {
        return this.add(url, after);
    }

    nonce(...nonces: string[]): this {
        nonces.forEach((nonce) => this.add(`'${nonce}'`));

        return this;
    }

    reportSample(): this {
        return this.add("'report-sample'");
    }

    toString(): string {
        if (this.postfix) {
            return `${this.field}-${this.postfix} ${this.values.join(' ')}`;
        }

        return `${this.field} ${this.values.join(' ')}`;
    }
}
