import { CSP } from 'lib/csp/CSP';

export function getCSP(): string {
    const csp = new CSP();

    csp.reportURI().url('https://csp.yandex.net/csp?from=vlootkit.auth&project=drivematics');

    csp.default().none();

    csp.baseURI().none();

    csp.script()
        .nonce('sha256-KQFslTpx/F8ra319rRGzpCwO/Jv0CBIkvVkO0rGoE24=') // auth.html
        .nonce('sha256-leCb9PMM6xScb1C6a7z4akXLoMf+Vv9e+dDhHPpUoQk=') // registration.html
        .nonce('sha256-lQ3evNzOW0707WfsGm1Pwquy+ub4xc1ES6aAztekE0Y=') // restore.html
        .nonce('sha256-rAFhtCAj6dNiiK3XDk/XmKkLppaArjpdVZ8MDm9egvM=') // profile.html
        .reportSample();

    csp.style().nonce('sha256-kMQyHMCeIIImV+Q6+qJW4vW3HCdldMIuqhl5cM1sNiY=').reportSample();

    csp.font().url('yastatic.net');

    csp.img().self().data().url('vlootkit-frontend.s3.eu-central-1.amazonaws.com');

    csp.connect().self().url('vlootkit-frontend.s3.eu-central-1.amazonaws.com').url('yastatic.net');

    csp.child().none();

    return csp.toString();
}
