import crypto from 'node:crypto';

export function generateCsrfToken(vuid: string, timestamp: number, secret: string): string {
    const time = String(timestamp);
    const data = vuid + ':' + time;
    const hash = crypto.createHmac('sha1', secret).update(data).digest('hex');

    return hash + ':' + time;
}
