import { generateCsrfToken } from 'lib/csrf/generateCsrfToken/generateCsrfToken';

// eslint-disable-next-line @typescript-eslint/no-magic-numbers
const CSRF_TTL = 24 * 60 * 60 * 1000; // 1d

export function validateCsrfToken(token: string | undefined, vuid: string | undefined, secret: string): boolean {
    if (!token || !vuid) {
        return false;
    }

    const parts = token.split(':');

    if (parts.length === 2) {
        const timestamp = Number(parts[1]);
        const lifetime = Date.now() - timestamp;

        if (!isNaN(timestamp) && lifetime >= 0 && lifetime < CSRF_TTL) {
            const originalToken = generateCsrfToken(vuid, timestamp, secret);

            return token === originalToken;
        }
    }

    return false;
}
