import yandexLogger, { LoggerOptions } from '@yandex-int/yandex-logger';
import presetDefault from '@yandex-int/yandex-logger/middleware/preset-default';
import streamDeploy from '@yandex-int/yandex-logger/streams/deploy';
import streamLine from '@yandex-int/yandex-logger/streams/line';

const config: LoggerOptions = {
    name: 'vlootkit-auth',
    fields: {
        ver: process.env.DM_VERSION,
    },
    streams: process.env.DM_YDEPLOY
        ? [
              {
                  level: 'info',
                  stream: streamDeploy(),
              },
          ]
        : [
              {
                  level: 'trace',
                  stream: streamLine({
                      template: '[{{date}}] {{levelName}}: {{msg}}{{#err}}\n{{err.stack}}{{/err}}',
                  }),
              },
          ],
    middleware: [...presetDefault()],
};

export const logger = yandexLogger(config);
