import { IncomingMessage } from 'node:http';

import { parse } from 'cookie';

import { getReqHeaderStr } from 'lib/request/getReqHeaderStr/getReqHeaderStr';

export type ReqLang = 'en' | 'ru';

const LANGS = {
    en: true,
    ru: true,
};

const DEFAULT_LANG = 'en';
const MAX_HEADER_SIZE = 1024;

export function getReqLang(req: IncomingMessage): ReqLang {
    const cookies = parse(getReqHeaderStr(req, 'cookie') || '');

    if (cookies && cookies.dm_lang && LANGS.hasOwnProperty(cookies.dm_lang)) {
        return cookies.dm_lang as ReqLang;
    }

    const langs = getReqHeaderStr(req, 'accept-language');

    const parts: string[] = langs && langs.length < MAX_HEADER_SIZE ? langs.split(',') : [];

    const items: Array<{ lang: string; code: string; q: number }> = parts
        .map((item) => {
            const parts = item.toLowerCase().split(';q=');
            const code = parts[0].trim();
            const q = parts[1] ? Number(parts[1]) || 1 : 1;
            const langParts = code.split('-');

            return {
                lang: langParts[0].trim(),
                code,
                q,
            };
        })
        .sort((a, b) => {
            return b.q - a.q;
        });

    const item = items.find((item) => {
        return LANGS.hasOwnProperty(item.lang);
    });

    return item ? (item.lang as ReqLang) : DEFAULT_LANG;
}
