import { IncomingMessage } from 'node:http';

import getRawBody from 'raw-body';

import { getReqHeaderStr } from 'lib/request/getReqHeaderStr/getReqHeaderStr';

// eslint-disable-next-line @typescript-eslint/no-magic-numbers
const BODY_SIZE_LIMIT = 10 * 1024; // 10kb

export function parseReqStream<T>(req: IncomingMessage, limit: number = BODY_SIZE_LIMIT): Promise<T> {
    return getRawBody(req, {
        length: Number(getReqHeaderStr(req, 'content-length')),
        limit,
        encoding: 'utf-8',
    }).then((str) => JSON.parse(str));
}
