import { ServerResponse } from 'node:http';

export function setResSecurityHeaders(res: ServerResponse, csp: string, trustedReferer?: boolean): void {
    res.setHeader('X-XSS-Protection', '1; mode=block');
    res.setHeader('X-Content-Type-Options', 'nosniff');

    if (!trustedReferer) {
        res.setHeader('X-Frame-Options', 'SAMEORIGIN');
    }

    res.setHeader('Content-Security-Policy', csp);
}
