import crypto from 'node:crypto';

const SECOND = 1000;

const MIN_VUID = 1000000;
const MAX_VUID = 1000000000;

export function generateVuid(): Promise<string> {
    return new Promise((resolve, reject) => {
        crypto.randomInt(MIN_VUID, MAX_VUID, (error, value) => {
            if (error) {
                return reject(error);
            }

            const time = Math.round(Date.now() / SECOND);

            resolve(String(value) + String(time));
        });
    });
}
