(function() {
    const demo = document.querySelector('[data-id="demo"]');
    const form = document.querySelector('#req-demo');
    const button = form.querySelector('.button_primary');

    demo.addEventListener('click', function(event) {
        event.preventDefault();
        form.scrollIntoView({behavior: 'smooth', block: 'center', inline: 'nearest'})
    });

    button.addEventListener('click', send);
    form.addEventListener('submit', function(event) {
        event.preventDefault();
        send();
        return false;
    });

    let lock = false;
    function send() {
        if (lock) {
            return;
        }
        lock = true;

        const fields = ['email', 'phone', 'comment'];
        let data = [];
        let isValid = false;

        for (let i = 0; i < fields.length; i++) {
            const name = fields[i];
            const value = form.querySelector('[data-id="' + name + '"]').value;

            if ((name === 'email' || name === 'phone') && value) {
                isValid = true;
            }

            data.push({
                caption: name,
                value: value,
            });
        }

        if (!isValid) {
            lock = false;
            return;
        }

        button.innerText = 'Sending...';

        fetch('/web-api/request/demo', {method: 'POST', body: JSON.stringify(data)})
            .then((req) => req.json())
            .then((data) => {
                button.innerText = data.ok ? 'Thank you for request' : 'Ooops... Please try again later';
                lock = false;
            })
            .catch(() => {
                button.innerText = 'Ooops... Please try again later';
                lock = false;
            });
    }
})()
