const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const webpackCommonConfig = require('../configs/webpack/webpack.common');

module.exports = {
  "typescript": { reactDocgen: 'react-docgen' },
  "stories": ["../src/**/*.story.(tsx|ts)"],
  "core": {
    builder: "webpack5",
  },
  "addons": [
    "@storybook/addon-actions"
  ],
  "webpackFinal": (config) => {
    return {
      ...config,
      plugins: [
        ...config.plugins,
        new MiniCssExtractPlugin({
          filename: '[name].[contenthash].css',
          chunkFilename: '[name].[contenthash].css',
          ignoreOrder: true,
        }),
      ],
      module: {
        ...config.module,
        rules: webpackCommonConfig().module.rules,
      }
    }
  }
}
