#!/bin/bash

function init {
  # get cli arguments (-d is optional)
  while getopts "d" option
  do
    case "${option}" in
      d) DEPLOY_TARGET=${option};;
      *)
    esac
  done

  VERSION=$(node -e "console.log(require('./package.json').version)")
  RELEASE_FOLDER=releases
  MAX_RELEASE_COUNT=5
}

function cleanOldReleases {
  # grep -c ^d - count directories in $RELEASE_FOLDER
  RELEASE_COUNT=$(ls -l "$RELEASE_FOLDER" | grep -c ^d);

  # -gt -> greater than
  if [ "$RELEASE_COUNT" -gt "$MAX_RELEASE_COUNT" ]; then
    cd "$RELEASE_FOLDER" || exit;
    # list files sorted by mtime, reverse the list and get 1st line
    rm -rf "$(ls -tr | HEAD -1)";
  fi;
}

function buildRelease {
  init;
  # | tee <file>.log means that stdout and stderr of the scripts should be copied to <file>.log
  npm run build | tee build_release.log;

  if [ "${PIPESTATUS[0]}" == 0 ]; then
    node uploadSourceMapsToEB.js | tee -a build_release.log && \
    rm -rf dist/source-maps;
  fi;

  if [ "$DEPLOY_TARGET" == 'production' ]; then
    mkdir -p "$RELEASE_FOLDER"/"$VERSION"  && cp -r dist/* "$RELEASE_FOLDER"/"$VERSION";
  fi;
}

# exit on error
set -e;
set -o pipefail

buildRelease;
cleanOldReleases;


