const path = require('path');
const WebpackNotifierPlugin = require('webpack-notifier');

module.exports = {
    plugins: [
        new WebpackNotifierPlugin({
            excludeWarnings: true,
            title: 'Webpack'
        })
    ],
    devtool: 'eval-cheap-module-source-map',
    devServer: {
        contentBase: path.join(__dirname, '../../dist'),
        compress: true,
        port: 9000,
        disableHostCheck: true,
        host: '0.0.0.0',
        stats: {
            assetsSort: '!size',
            colors: true,
            logging: 'error',
            reasons: false,
            children: false,
            usedExports: false
        },
        https: true,
        headers: {
            'Cache-Control': 'max-age=31536000'
        },
        proxy: {
            '/signal-fleet/*': {
                target: 'https://fleet.yandex-team.ru/api/fleet/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '^/signal-fleet': ''
                }
            },
            '/tst-fleet/*': {
                target: 'https://fleet.tst.yandex-team.ru/api/fleet/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '^/tst-fleet': ''
                }
            },
            '/samsara/*': {
                target: 'https://samsara.yandex-team.ru/api/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '^/samsara': ''
                }
            },
            '/sip/*': {
                target: 'https://tel.yandex-team.ru/dev/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '^/sip': ''
                }
            },
            '/saasnew/*': {
                target: 'https://prestable.carsharing.yandex-team.ru/saasnew/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '^/saasnew': ''
                }
            },
            '/front/*': {
                target: 'https://carsharing-testing.n.yandex-team.ru/beta/front/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '^/front': ''
                }
            },
            '/analytics': {
                target: 'https://dajr.yandex-team.ru/',
                //target: 'http://da.man.yp-c.yandex.net:4242/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '^/analytics': ''
                }
            },
            "/dajr-prestable": {
                target: 'https://prestable.dajr.yandex-team.ru/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {"^/dajr-prestable": ""}
            },
            "/dajr-testing": {
                target: 'https://testing.dajr.yandex-team.ru/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {"^/dajr-testing": ""}
            },
            '/py/*': {
                target: 'https://carsharing.n.yandex-team.ru/api/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '^/py': ''
                }
            },
            '/p-testing/*': {
                target: 'https://carsharing-testing.n.yandex-team.ru/api/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '^/p-testing': ''
                }
            },
            '/p-qa/*': {
                target: 'https://carsharing-prestable.n.yandex-team.ru/api/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '/p-qa': ''
                }
            },
            '/hitman-execution/*': {
                target: 'https://hitman.yandex-team.ru/api/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '/hitman-execution': ''
                }
            },
            '/yt/*': {
                target: 'https://carsharing.yandex-team.ru/yt/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '/yt': ''
                }
            },
            '/yql/*': {
                target: 'https://yql-api.yandex-team.ru',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '/yql': ''
                }
            },
            '/st-api/*': {
                target: 'https://st-api.yandex-team.ru/v2/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '/st-api': ''
                }
            },
            '/chat-api-test/*': {
                target: 'http://localhost:7000/chat-api-test/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '^/chat-api-test/': ''
                }
            },
            '/idm-api/*': {
                target: 'https://idm-api.yandex-team.ru/api/v1/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '^/idm-api': ''
                }
            },
        }
    }
};
