const OptimizeCSSAssetsPlugin = require("optimize-css-assets-webpack-plugin");
const TerserPlugin = require('terser-webpack-plugin');

module.exports = {
    output: {
        sourceMapFilename: "source-maps/[name].[contenthash:8].js.map",
    },
    devtool: 'hidden-source-map',
    optimization: {
        minimize: true,
        runtimeChunk: 'single',
        minimizer: [
            new OptimizeCSSAssetsPlugin({
                cssProcessorOptions: {
                    safe: true,
                    discardComments: {
                        removeAll: true,
                    },
                },
            }),
            new TerserPlugin({
                test: /(\.tsx?$|\.js(\?.*)?$)/i,
            })
        ]
    },
};
