module.exports = {
    globals: {
        'ts-jest': {
            diagnostics: false,
            isolatedModules: true
        },
    },
    transform: {
        '.(ts|tsx)': 'ts-jest',
    },
    testPathIgnorePatterns: [
        '/node_modules/',
        '/lib/',
    ],
    testRegex: '(/test/.*|\\.(test|spec))\\.(ts|tsx|js)$',
    moduleFileExtensions: [
        'js',
        'json',
        'ts',
        'tsx',
    ],
    reporters: [
        "default",
        ["./node_modules/jest-html-reporter", {
            "pageTitle": "jest report",
            "outputPath": "./jest-report.html",
            "includeFailureMsg": true,
            "includeConsoleLog": true,
            "statusIgnoreFilter": "passed",
            "sort": "status",
        }]
    ],
    moduleNameMapper: {
        '\\.(css|less|png)$': 'identity-obj-proxy',
        "\\.component\.svg": "<rootDir>/src/__mocks__/svgrMock.js"
    },
    setupFiles: [
        './setupTests.js',
        'jest-canvas-mock',
    ],
    setupFilesAfterEnv: [
        './setupTestsAfterEnv.js'
    ],
    preset: 'ts-jest',
    testMatch: null,
    snapshotSerializers: ['enzyme-to-json/serializer'],
    testEnvironment: 'jsdom'
};
