import React from 'react';

import { Button, ButtonTypes } from '../../ui/Button';
import { Link } from '../../ui/Link';
import { buttonLocationDetails, buttonNameDetails } from '../../utils/sendLogs/eventTypes/buttonDetails';
import style from './index.css';

interface IActiveChatsCounterProps {
    isLoading?: boolean;
    disabled?: boolean;
    user_id?: string;
    tags?: any[];
}

export const IGNORE_CHAT_TAGS = ['support_chat_waiting_feedback'];

export class ActiveChatsCounter extends React.Component<IActiveChatsCounterProps, any> {
    getActiveChats() {
        return this.props?.tags?.filter(tag => {
            return tag.topic_link
                && !IGNORE_CHAT_TAGS.includes(tag.tag); //#DRIVEFRONT-636
        }) || [];
    }

    render() {
        const activeChats = this.getActiveChats();
        const button = <Button colorType={ButtonTypes.positive}
                               isLoading={this.props.isLoading}
                               className={style.chat_btn}
                               ytLog={{
                                   button_name: buttonNameDetails.ACTIVE_CHATS,
                                   location: buttonLocationDetails.CLIENT_CARD,
                               }}>
            Чаты {activeChats.length
                ? `| Активных: ${activeChats.length}`
                : ''}
        </Button>;

        return <div> {
            this.props.disabled
                ? button
                : <Link href={`${location.origin}${location.pathname}#/chats?user_id=${this.props.user_id}`}
                        target={'_blank'}>
                    {button}
                </Link>
        }
        </div>;
    }
}
