import * as React from 'react';

import { EMPTY_DATA, ONE_SECOND } from '../../../../constants';
import { FormatDateInString } from '../../../../ui/FormatDate';
import coreStyles from '../index.css';

interface IAnalyticsGarageItemProps {
    fields?: {name: string}[];
    item?: {fields: any[]; vin: string};
}

export const AnalyticsGarageItem = (props: IAnalyticsGarageItemProps) => {
    const { fields, item } = props;

    return <tr className={coreStyles.garageItem}>
        <td>{item?.vin}</td>
        {fields?.map(({ name }, index) => {
            const itemFieldValues = item?.fields?.[name]?.values;

            return <td key={index}>
                {itemFieldValues?.map(({ value, begin_time, end_time }, index) => {
                    const valueText = `нач. ${
                        FormatDateInString({ value: begin_time * ONE_SECOND }) ?? EMPTY_DATA} | кон. ${
                        FormatDateInString({ value: end_time * ONE_SECOND }) ?? EMPTY_DATA
                    }`;

                    return <span key={index}>
                        <strong>{value}</strong>
                        <br/>
                        <span>{valueText}</span>
                    </span>;
                }) ?? EMPTY_DATA}
            </td>;
        })}
    </tr>;
};
