import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_VIN_INFO = 'GET_VIN_INFO',
    UPLOAD_GARAGE_XLSX = 'UPLOAD_GARAGE_XLSX',
    ROLLBACK_MUTATION_ID = 'ROLLBACK_MUTATION_ID'
}

export const ANALYICS_GARAGE_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_VIN_INFO]: {
        apiPrefix: API_PREFIXES.ANALYTICS_NEW,
        api: 'garage/vins-info',
        cgiObj: {
            begin: null, // vin
            limit: null, // 100 by default
            time: null, // snapshot timestamp
        },
    },
    [REQUESTS.UPLOAD_GARAGE_XLSX]: {
        apiPrefix: API_PREFIXES.ANALYTICS_NEW,
        api: 'garage/upload-file',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.ROLLBACK_MUTATION_ID]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.ANALYTICS_NEW,
        api: 'garage/mutations/${ID}/rollback',
    },
};
