import React, { useEffect, useState } from 'react';

import { Link } from '../../../ui/Link';
import { Request2 } from '../../../utils/request';
import { SimpleError } from '../../SimpleError';
import Spin from '../../Spin';
import styles from './index.css';
import { CORE_DASHBOARDS_REQUESTS,REQUESTS } from './request';

const RenderList = (props) => {
    const { list } = props;

    return <ul className={styles.list}>
        {list.map((item, index) => <li key={index} className={styles.list__item}>
            <Link className={styles.list__link} href={item.link} target={'__blank'}>{item.title}</Link>
            {item.tabs && <RenderList list={item.tabs}/>}
        </li>)}
    </ul>;
};

const Dashboard = () => {
    const request = new Request2({ requestConfigs: CORE_DASHBOARDS_REQUESTS });
    const [isLoading, setIsLoading] = useState(false);
    const [data, setData] = useState([]);
    const [error, setError] = useState(false);

    useEffect(() => {
        setIsLoading(true);
        request.exec(REQUESTS.GET_DASHBOARDS_LIST)
            .then(response => {
                setData(JSON.parse(response.Data));
                setIsLoading(false);
            })
            .catch(error => {
                setIsLoading(false);
                setError(error);
            });
    }, []);

    return <>
        {isLoading
            ? <Spin/>
            : error
                ? <SimpleError error={error}/>
                : <RenderList list={data}/>}
    </>;
};

export default Dashboard;
