import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_JOBS_LIST = 'GET_JOBS_LIST',
    GET_RUNS_LIST = 'GET_RUNS_LIST',
    RUN_TASK = 'RUN_TASK',
}

export const CORE_DRIVE_LENS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_JOBS_LIST]: {
        apiPrefix: API_PREFIXES.ANALYTICS,
        api: 'api/tree/list/4',
    },
    [REQUESTS.RUN_TASK]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.ANALYTICS,
        api: 'api/action/run/${id}',
    },
    [REQUESTS.GET_RUNS_LIST]: {
        apiPrefix: API_PREFIXES.ANALYTICS,
        api: 'api/tasks',
        cgiObj: {
            Page: null,
            PerPage: 25,
        },
    },
};
