import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_REGISTRY = 'GET_REGISTRY',
    UPDATE_REGISTRY = 'UPDATE_REGISTRY',
    DELETE_REGISTRY = 'DELETE_REGISTRY'
}

export const REGISTRY_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_REGISTRY]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.ANALYTICS_NEW,
        api: 'registry/query',
    },
    [REQUESTS.UPDATE_REGISTRY]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.ANALYTICS_NEW,
        api: 'registry/upsert',
    },
    [REQUESTS.DELETE_REGISTRY]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.ANALYTICS_NEW,
        api: 'registry/delete',
    },
};
