import React from 'react';

import { NIL_OPERATORS, SimpleJSONEQueryOperand } from '../SimpleJSONEQueryOperand/component';
import style from './index.css';

export class LogicalJSONEQuery extends React.Component<any, any> {
    onDeleteClick(index: number) {
        const json: any = this.props.json;
        if (this.props.initJson) {
            const data = Object.assign({}, this.props.initJson);
            const currentOperands = Object.assign({}, this.props.initJson);
            if (index !== null) {
                this.props.initIndex.reduce((res: any, currentInitIndex: number, arrIndex: number, arr: any[]) => {
                    res = res.Operands[currentInitIndex];
                    if (arrIndex === arr.length - 1) {
                        res.Operands.splice(index, 1);
                    }

                    return res;
                }, currentOperands);
            } else {
                this.props.initIndex.reduce((res: any, currentInitIndex: number, arrIndex: number, arr: any[]) => {
                    if (arrIndex === arr.length - 1) {
                        res.Operands.splice(currentInitIndex, 1);
                    }

                    res = res.Operands[currentInitIndex];

                    return res;
                }, currentOperands);
            }

            this.props.onChange(data);
        } else {
            json.Operands.splice(index, 1);
            this.props.onChange(json);
        }
    }

    onAddClick() {
        if (this.props.disabled) {
            return;
        }

        const json: any = this.props.json;
        const { Operands: operands } = json;
        if (this.props.initJson) {
            const data = Object.assign({}, this.props.initJson);
            const currentOperands = Object.assign({}, this.props.initJson);
            this.props.initIndex.reduce((res: any, index: number, arrIndex: number, arr: any[]) => {
                res = res.Operands[index];
                if (arrIndex === arr.length - 1) {
                    res.Operands.push({
                        'Type': '',
                        'Field': '',
                        'Value': '',
                    });
                }

                return res;
            }, currentOperands);
            this.props.onChange(data);
        } else {
            operands.push({
                'Type': '',
                'Field': '',
                'Value': '',
            });
            this.props.onChange(json);
        }
    }

    onGroupAddClick() {
        if (this.props.disabled) {
            return;
        }

        const json: any = this.props.json;
        const { Operands: operands } = json;
        if (this.props.initJson) {
            const data = Object.assign({}, this.props.initJson);
            const currentOperands = Object.assign({}, this.props.initJson);
            this.props.initIndex.reduce((res: any, index: number, arrIndex: number, arr: any[]) => {
                res = res.Operands[index];
                if (arrIndex === arr.length - 1) {
                    res.Operands.push({
                        Type: 'LogicalAnd',
                        Operands: [
                            {
                                'Type': '',
                                'Field': '',
                                'Value': '',
                            },
                            {
                                'Type': '',
                                'Field': '',
                                'Value': '',
                            },
                        ],
                    });
                }

                return res;
            }, currentOperands);
            this.props.onChange(data);
        } else {
            operands.push({
                Type: 'LogicalAnd',
                Operands: [
                    {
                        'Type': '',
                        'Field': '',
                        'Value': '',
                    },
                    {
                        'Type': '',
                        'Field': '',
                        'Value': '',
                    },
                ],
            });
            this.props.onChange(json);
        }
    }

    changeLogicalType(newType: string) {
        if (this.props.disabled) {
            return;
        }

        const json: any = this.props.json;
        if (this.props.initJson) {
            const data = Object.assign({}, this.props.initJson);
            const currentOperands = Object.assign({}, this.props.initJson);
            this.props.initIndex.reduce((res: any, index: number, arrIndex: number, arr: any[]) => {
                res = res.Operands[index];
                if (arrIndex === arr.length - 1) {
                    res.Type = newType;
                }

                return res;
            }, currentOperands);
            this.props.onChange(data);
        } else {
            json.Type = newType;
            this.props.onChange(json);
        }
    }

    onOperandChange(index: number, newValues: any) {
        if (this.props.disabled) {
            return;
        }

        const json: any = this.props.json;
        const { type: Type, value: Value, field: Field } = newValues;
        const newValuesObj = { Field, Type, Value };

        if (Object.entries(NIL_OPERATORS).map(item => item[1].value).includes(Type)) {
            delete newValuesObj.Value;
        }

        if (this.props.initJson) {
            const data = Object.assign({}, this.props.initJson);
            const currentOperands = Object.assign({}, this.props.initJson);
            this.props.initIndex.reduce((res: any, currentInitIndex: number, arrIndex: number, arr: any[]) => {
                res = res.Operands[currentInitIndex];
                if (arrIndex === arr.length - 1) {
                    res.Operands[index] = Object.assign({}, newValuesObj);
                }

                return res;
            }, currentOperands);
            this.props.onChange(data);
        } else {
            json.Operands[index] = Object.assign({}, newValuesObj);
            this.props.onChange(json);
        }
    }

    render() {
        const json: any = this.props.json;
        const { Type: type, Operands: operands } = json;

        return <div className={style.logical_query}>
            {!this.props.disabled && <div className={style.control_container}>
                <div className={style.add_condition} onClick={this.onAddClick.bind(this)}>Условие</div>
                <div className={style.add_group} onClick={this.onGroupAddClick.bind(this)}>Группа</div>
                {this.props.initJson
                    ? <div className={style.delete}
                           onClick={this.onDeleteClick.bind(this, null)}>
                        Удалить
                    </div>
                    : null}
            </div>}
            <div className={style.logical_type}>
                <div className={type === 'LogicalAnd' ? style.active : ''}
                     onClick={this.changeLogicalType.bind(this, 'LogicalAnd')}>И
                </div>
                <div className={type === 'LogicalOr' ? style.active : ''}
                     onClick={this.changeLogicalType.bind(this, 'LogicalOr')}>ИЛИ
                </div>
            </div>
            <div className={style.logical_operands}>
                {operands && operands.map((operand: any, index: number) => {
                    const { Type: type } = operand;
                    if (type === 'LogicalAnd' || type === 'LogicalOr') {
                        return <div key={`operand_${index}`} className={style.logical_operand}>
                            <LogicalJSONEQuery initJson={this.props.initJson || json}
                                               initIndex={this.props.initIndex
                                                   ? this.props.initIndex.concat(index)
                                                   : [index]}
                                               onChange={this.props.onChange.bind(this)}
                                               fields={this.props.fields}
                                               json={operand}/>
                        </div>;
                    }

                    const { Field: field, Value: value } = operand;

                    return <div key={`operand_${index}`} className={style.logical_operand}>
                        <div className={style.control_container}>
                            <div className={style.delete} onClick={this.onDeleteClick.bind(this, index)}>Удалить
                            </div>
                        </div>
                        <SimpleJSONEQueryOperand fields={this.props.fields}
                                                 disabled={this.props.disabled}
                                                 onChange={this.onOperandChange.bind(this, index)}
                                                 value={value}
                                                 type={type}
                                                 field={field}/>
                    </div>;

                })}
            </div>
        </div>;
    }
}
