import React from 'react';

import style from './index.css';
import { LogicalJSONEQuery } from './LogicalJSONEQuery/component';

interface ILogicalJSONEditorProps {
    json: string;
    fields: { [key: string]: any };
    onChange: (json: { [key: string]: any }) => void;
    disabled?: boolean;
}

interface ILogicalJSONEditorState {
    json: { [key: string]: any };
}

const LOGICAL_AND_OPERATOR = 'LogicalAnd';
const LOGICAL_OR_OPERATOR = 'LogicalOr';

export class LogicalJSONEditor extends React.Component<ILogicalJSONEditorProps, ILogicalJSONEditorState> {
    state = {
        json: {},
    };

    componentDidMount(): void {
        const { json } = this.props;
        this.setDataInState(json);
    }

    UNSAFE_componentWillUpdate(
        nextProps: Readonly<ILogicalJSONEditorProps>,
        nextState: Readonly<ILogicalJSONEditorState>,
        nextContext: {},
    ): void {
        if (this.props.json !== nextProps.json) {
            this.setDataInState(nextProps.json);
        }
    }

    setDataInState(json: any) {
        if (json) {
            json = typeof json === 'string' ? JSON.parse(json) : json;
            const { Type: type } = json;
            if (type !== LOGICAL_AND_OPERATOR && type !== LOGICAL_OR_OPERATOR) {
                json = {
                    Type: LOGICAL_AND_OPERATOR,
                    Operands: type ? [json] : [],
                };
            }

            this.setState({ json });
        }
    }

    onChange(value: any) {
        this.setState({ json: value }, () => {
            this.props.onChange(this.state.json);
        });
    }

    render() {
        const json: any = this.state.json;

        return <div className={style.logical_query_builder}>
            <LogicalJSONEQuery disabled={this.props.disabled}
                               fields={this.props.fields}
                               onChange={this.onChange.bind(this)}
                               json={json}/>
        </div>;
    }
}
