import React from 'react';

import LinkIcon from '../../../../../svg-components/link.component.svg';
import { Link } from '../../../../ui/Link';
import { DisplayType } from '../ObjectView/constants';
import { IResource } from '../types';
import style from './index.css';

interface IResourceProps {
    resources: IResource[];
}

export const Resources = (props: IResourceProps) => {
    const { resources } = props;

    return <div className={style.resources}>
        {resources.map((resource, index) => {
            if (resource.Meta) {
                switch (resource.Meta['@DisplayType']) {
                case DisplayType.LINK:
                    return <Link href={resource.Meta.Link}
                                 target={'_blank'}
                                 key={index}
                                 className={style.resources__resource}>
                        <LinkIcon className={style.resources__svg}/>
                        <div>
                            <div>{resource.Title}</div>
                            <div className={style.resources__description}>{resource.Meta['@Description']}</div>
                        </div>
                    </Link>;
                default:
                    return <Link className={style.resources__resource}
                                 href={resource.Meta.Link}
                                 target={'_blank'}
                                 key={index}>
                        <div>
                            <div>{resource.Title}</div>
                            <div className={style.resources__description}>{resource.Meta['@Description']}</div>
                        </div>
                    </Link>;
                }
            } else {
                return <></>;
            }
        },
        )}
    </div>;
};
