import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_DIR = 'GET_DIR',
    GET_MANAGER_ACTIONS_LIST = 'GET_ACTIONS_LIST',
    RUN_TASK = 'RUN_TASK',
    GET_ACTION = 'GET_ACTION',
    GET_TASK = 'GET_TASK',
    GET_TASK_LOG = 'GET_TASK_LOG',
    ABORT_TASK = 'ABORT_TASK',
    CREATE_SECRET = 'CREATE_SECRET',
    GET_SECRET = 'GET_SECRET',
    UPDATE_SECRET = 'UPDATE_SECRET',
    DELETE_SECRET = 'DELETE_SECRET'
}

export const CORE_DRIVE_LENS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_DIR]: {
        apiPrefix: API_PREFIXES.ANALYTICS,
        api: 'api/tree/list/${id}',
    },
    [REQUESTS.GET_MANAGER_ACTIONS_LIST]: {
        apiPrefix: API_PREFIXES.ANALYTICS,
        api: 'api/tree/list/4',
    },
    [REQUESTS.GET_ACTION]: {
        apiPrefix: API_PREFIXES.ANALYTICS,
        api: 'api/actions/${id}',
    },
    [REQUESTS.GET_TASK]: {
        apiPrefix: API_PREFIXES.ANALYTICS,
        api: 'api/tasks/${id}',
    },
    [REQUESTS.GET_TASK_LOG]: {
        apiPrefix: API_PREFIXES.ANALYTICS,
        api: 'api/tasks/${id}/logs/${logType}',
    },
    [REQUESTS.RUN_TASK]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.ANALYTICS,
        api: 'api/actions/${id}',
    },
    [REQUESTS.ABORT_TASK]: {
        method: REQUEST_METHOD.DELETE,
        apiPrefix: API_PREFIXES.ANALYTICS,
        api: 'api/tasks/${id}',
    },
    [REQUESTS.CREATE_SECRET]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.ANALYTICS,
        api: 'api/secrets',
    },
    [REQUESTS.GET_SECRET]: {
        method: REQUEST_METHOD.GET,
        apiPrefix: API_PREFIXES.ANALYTICS,
        api: 'api/secrets/${id}',
    },
    [REQUESTS.UPDATE_SECRET]: {
        method: REQUEST_METHOD.PATCH,
        apiPrefix: API_PREFIXES.ANALYTICS,
        api: 'api/secrets/${id}',
    },
    [REQUESTS.DELETE_SECRET]: {
        method: REQUEST_METHOD.DELETE,
        apiPrefix: API_PREFIXES.ANALYTICS,
        api: 'api/secrets/${id}',
    },
};
