import { DisplayType } from './ObjectView/constants';

export interface IOption {
    Type: string;
    Title: string;
    Description: string;
    Settings: {
        [key: string]: any;
    };
    Value: { [key: string]: any } | number | string;
    Visible: boolean;
    Editable: boolean;
}

export interface IAction {
    ID: number;
    DirID: number;
    Type: string;
    Title: string;
    Description?: string;
    OwnerID?: string;
    Options: { [key: string]: IOption };
    Tasks?: ITask[];
}

export interface IResource {
    CreateTime: number;
    ID: number;
    Meta?: {
        '@DisplayType'?: DisplayType;
        '@Description'?: string;
        Link?: string;
    };
    taskID?: number;
    Title: string;
}

export interface ITask {
    ID: number;
    Action: IAction;
    ActionID: number;
    OwnerID?: string;
    Status: string;
    CreateTime: number;
    UpdateTime: number;
    Resources?: IResource[];
    Settings: {
        [key: string]: IOption;
    };
    Options: {
        [key: string]: IOption;
    };
}

export interface IPlanner {
    ActionID: number;
    CreateTime: number;
    DirID: number;
    ID: number;
    NextTime: number;
    Options: {
        [key: string]: IOption;
    };
    OwnerID: string;
    Settings: {
        [key: string]: IOption;
    };
    Title: string;
}

export interface ISecret {
    ID?: number | undefined;
    DirID: number;
    Title: string;
    Type: string;
    Data: {
        SecretID: string;
        VersionID: string;
        Key: string;
    };
}

export enum OBJECTS_ID_PARAM {
    action = 'actionID',
    runAction = 'runActionID',
    task = 'taskID',
    dir = 'dirID',
    planner = 'plannerID',
    secret = 'secretID',
    config = 'configID',
    resource = 'resourceID'
}
