import { storiesOf } from '@storybook/react';
import React, { useState } from 'react';

import { Button } from '../../../../ui/Button';
import { Popup } from './index';

const Wrapper = () => {
    const [isOpen, setIsOpen] = useState(false);

    return <div>
        <Button basic={true} onClick={() => setIsOpen(true)}>Открыть</Button>
        <Popup isOpen={isOpen} togglePopup={setIsOpen}>
            <div>Директорию</div>
            <div>Действие</div>
            <div>Планировщик</div>
            <div>Задание</div>
            <div>Конфигурацию</div>
            <div>Секрет</div>
            <div>Файл</div>
        </Popup>
    </div>;
};

storiesOf('Popup', module).add('default', () => <Wrapper/>);
