import React, { memo, ReactNode,useEffect, useRef } from 'react';

import styles from './index.css';

interface IPopup {
    isOpen: boolean;
    togglePopup: (boolean) => void;
    children: ReactNode;
}

export const Popup = memo((props: IPopup) => {
    const { isOpen, togglePopup, children } = props;
    const container = useRef<HTMLDivElement>(null);

    useEffect(() => {
        document.addEventListener('mousedown', onMouseDown);

        return () => {
            document.removeEventListener('mousedown', onMouseDown);
            document.removeEventListener('mouseup', onMouseUp);
        };
    }, []);

    const onMouseDown = (event: MouseEvent) => {
        if (container.current && !container.current.contains(event.target as Node)) {
            document.addEventListener('mouseup', onMouseUp);
        }
    };

    const onMouseUp = (event: MouseEvent) => {
        if (container.current && !container.current.contains(event.target as Node)) {
            togglePopup(false);
        }

        document.removeEventListener('mouseup', onMouseUp);
    };

    return <div className={`${styles.popup} ${isOpen && styles['popup_is-open']}`} ref={container}>
        {children}
    </div>;
});
