import React, { useEffect, useRef, useState } from 'react';

import styles from './index.css';

export const Cell = (props) => {
    const { value, onChange } = props;

    const [editable, setEditable] = useState(false);
    const [width, setWidth] = useState<number>();

    const inputRef = useRef<HTMLInputElement>(null);
    const blockRef = useRef<HTMLDivElement>(null);

    const onClick = (event: Event) => {
        if (event.target !== inputRef.current) {
            setEditable(false);
            document.removeEventListener('click', onClick);
        }
    };

    useEffect(() => {
        if (editable) {
            document.addEventListener('click', onClick);
            inputRef.current?.focus();
        }

        return () => {
            document.removeEventListener('click', onClick);
        };
    }, [editable]);

    return <>
        {editable
            ? <input className={styles.cell}
                     type="text"
                     style={{ width: width }}
                     value={value || ''}
                     onChange={onChange}
                     ref={inputRef}/>
            : <div className={styles.cell}
                   onDoubleClick={() => {
                       setWidth(blockRef.current?.offsetWidth);
                       setEditable(true);
                   }}
                   children={value || '*'}
                   ref={blockRef}/>
        }
    </>;
};
