import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import React from 'react';

import { Table } from './index';

const data = {
    Table: 'Wash',
    Columns: {
        city: { Type: 'string', Required: true },
        segment: { Type: 'string', Required: true },
        model: { Type: 'string', Required: false },
        product: { Type: 'string', Required: true },
        price: { Type: 'number', Required: true },
    },
    Rows: [
        { Values: { city: 'Москва', segment: 'econom', model: null, product: 'Легкая мойка машины', price: 250.50 } },
        { Values: { city: 'Москва', segment: 'business', model: null, product: 'Химчистка', price: 1200 } },
        { Values: { city: 'Питер', segment: 'econom', model: null, product: 'Легкая мойка', price: 230 } },
    ],
};

storiesOf('Table', module)
    .add('default', () => <Table head={Object.keys(data.Columns)}
                                 body={data.Rows.map(row => row.Values)}
                                 isLoading={false}
                                 onUpdate={action('change')}/>)
    .add('loading', () => <Table head={[]}
                                 body={[]}
                                 isLoading={true}/>);
