import React, { useEffect,useState } from 'react';

import TrashIcon from '../../../../../svg-components/trash.component.svg';
import { Button } from '../../../../ui/Button';
import { Cell } from './Cell';
import styles from './index.css';

interface IRow {
    [key: string]: any;
}

interface ITableProps {
    head: string[];
    body: IRow[];
    isLoading: boolean;
    isUpdating?: boolean;
    onUpdate?: (data: IRow[]) => void;
    skeletonColumn?: number;
    skeletonRow?: number;
}
export const Table = (props: ITableProps) => {
    const DEFAULT_SKELETON_COLUMN = 5;
    const DEFAULT_SKELETON_ROW = 6;
    const {
        head,
        body,
        isLoading,
        isUpdating,
        onUpdate,
        skeletonColumn = DEFAULT_SKELETON_COLUMN,
        skeletonRow = DEFAULT_SKELETON_ROW,
    } = props;
    const [data, setData] = useState<IRow[]>([]);

    useEffect(() => {
        setData(body);
    }, [body]);

    const update = (index, key, event) => {
        data[index][key] = event.target.value;
        setData([...data]);
    };

    const add = () => {
        data.push(head.reduce((acc, key) => ({ ...acc, [key]: '' }), {}));
        setData([...data]);
    };

    const remove = (index: number) => {
        data.splice(index, 1);
        setData([...data]);
    };

    return <div className={styles.table__wrapper}>
        <table className={styles.table + (isLoading ? ` ${styles.table_loading}` : '')}>
            <thead>
                <tr>
                    {isLoading
                        ? Array(skeletonColumn).fill(1).map((key, index) => <th key={index}>
                            <div className={styles.table__head_loading}/>
                        </th>)
                        : head.map(key => <th key={key} className={styles.table__head}>{key}</th>)}
                </tr>
            </thead>
            <tbody>
                {isLoading
                    ? Array(skeletonRow)
                        .fill(1)
                        .map((key, index) => <tr key={index} className={styles.table__row}>
                            {Array(skeletonColumn).fill(1).map((key, index) => <td key={index}>
                                <div className={styles.table__cell_loading}/>
                            </td>)}
                        </tr>)
                    : data.map((row, index) => <tr key={index} className={styles.table__row}>
                        {head.map(key => <td key={key} className={styles.table__cell}>
                            {
                                <Cell value={row[key]} onChange={update.bind(null, index, key)}/>
                            }
                        </td>)}
                        <td className={`${styles.table__cell} ${styles.table__cell_remove}`}
                            onClick={remove.bind(null, index)}>
                            <TrashIcon/>
                        </td>
                    </tr>,
                    )
                }
            </tbody>
        </table>
        <div className={styles.table__footer}>
            <Button basic
                    className={styles.table__button}
                    onClick={add}>Добавить</Button>
            {onUpdate && <Button isLoading={isUpdating}
                                 className={styles.table__button}
                                 onClick={onUpdate.bind(null, data)}>
                Сохранить
            </Button>}
        </div>
    </div>;
};
