import { applyMiddleware, combineReducers, createStore } from 'redux';
import { composeWithDevTools } from 'redux-devtools-extension';
import thunk from 'redux-thunk';

import * as reducers from '../../reducers';
import { AdminUserReducerState } from '../../reducers/adminUserReducer';
import { IChatReducerState } from '../../reducers/chatReducer';
import { LocalizationReducerState } from '../../reducers/localizationReducer';
import { IWebphoneReducerState } from '../../reducers/webphoneReducer';

interface IStore {
    AdminUser?: AdminUserReducerState;
    Lang?: LocalizationReducerState;
    Chats?: IChatReducerState;
    Constants?: any;
    Webphone?: IWebphoneReducerState;
}

const comReducers = combineReducers({
    AdminUser: reducers.adminUserReducer,
    Lang: reducers.localizationReducer,
    Chats: reducers.chatReducer,
    Constants: reducers.constantsReducer,
    Webphone: reducers.webphoneReducer,
});

const store = createStore(
    comReducers,
    composeWithDevTools(applyMiddleware(thunk)),
);

export { store, comReducers, IStore };
