import { IComponentRequest } from '../../../utils/request';

export const REQUESTS = {
    GET_ACCOUNT_TAGS_LIST: 'GET_ACCOUNT_TAGS_LIST',
    REMOVE_ACCOUNT_TAG: 'REMOVE_ACCOUNT_TAG',
    GET_ACCOUNT_TAG_DETAILS: 'GET_ACCOUNT_TAG_DETAILS',
};

export const requestConfigs: IComponentRequest = {
    [REQUESTS.GET_ACCOUNT_TAGS_LIST]: {
        api: 'account/tag/list',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.REMOVE_ACCOUNT_TAG]: {
        api: 'account/tag/remove',
        cgiObj: {
            tag_id: null,
        },
    },
    [REQUESTS.GET_ACCOUNT_TAG_DETAILS]: {
        api: 'account/tag/details',
        cgiObj: {
            event_id: null,
            tag_id: null,
        },
    },

};
