import * as React from 'react';

import { Button } from '../../../../ui/Button';
import { WalletAddModal } from '../../../Settings/Wallets/WalletAddModal';
import { DescriptionIcon } from '../utils/DescriptionIcon';
import styles from './index.css';

export const CreateWalletQueue = () => {
    const [showModal, openModal] = React.useState(false);

    return <>
        {showModal
            ? <WalletAddModal onClose={() => {
                openModal(false);
            }}
                              title={'Создать очередь'}/>
            : null
        }
        <div className={styles.createQueueComponent}>
            <Button onClick={() => {
                openModal(true);
            }}>
                Создать очередь
            </Button>
            <DescriptionIcon className={styles.queueHint}>
                <p>
                    <b>Очередь</b> - верхний уровень кошельков
                </p>
                <img src={'https://carsharing.s3.yandex.net/admin/static/b2b/wallet-queue-hint.png'}
                     alt={'Скриншот очереди в старых кошельках'}/>
            </DescriptionIcon>
        </div>
    </>;
};
