import React, { useState } from 'react';

import style from './index.css';

export enum Direction {
    LEFT = 'left',
    RIGHT = 'right',
}

interface IDescriptionIconProps {
    direction?: Direction;
    className?: string;
}

export const DescriptionIcon = (props: React.PropsWithChildren<IDescriptionIconProps>) => {
    const [isTooltipShow, setIsTooltipShow] = useState<boolean>(false);

    const onDescIconEnter = () => {
        setIsTooltipShow(true);
    };

    const onDescIconLeave = () => {
        setIsTooltipShow(false);
    };

    const { direction = Direction.RIGHT, children, className } = props;

    return <div className={`${style.desc_icon_container} ${className ?? ''}`}>
        <div className={`${style.desc_icon}`}
             onMouseEnter={onDescIconEnter}
             onMouseLeave={onDescIconLeave}>
            {isTooltipShow
                ? <div className={`${style.tooltip} ${style[direction]}`}>
                    {children}
                </div>
                : null}
        </div>
    </div>;
};
