import * as React from 'react';

import { Button, CancelButton } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import coreStyles from '../../../../ui/index.css';
import { Request2 } from '../../../../utils/request';
import { FormConstructor } from '../../../FormConstructor';
import { REQUESTS } from '../../request';
import { OVERDRAFT_SCHEMA } from './schema';

interface IBalanceOverdraftProps {
    onClose: () => void;
    accountId: string;
    request: Request2;
}

export const BalanceOverdraft = (props: IBalanceOverdraftProps) => {
    const { onClose, accountId, request } = props;
    const [formData, setFormData] = React.useState<{account_id; overdraft} | null>(null);
    const [error, setError] = React.useState<Error | null>();
    const [isLoading, setLoading] = React.useState<boolean>(false);

    const submitOverdraft = async () => {
        setLoading(true);
        try {
            await request.exec(REQUESTS.B2B_OVERDRAFT, {
                body: formData,
            });
            setLoading(false);
            onClose();
        } catch (error) {
            setLoading(false);
            setError(error);
        }
    };

    return <Window error={error}
                   onClose={onClose}
                   title={'Постоплата'}>
        <FormConstructor schema={OVERDRAFT_SCHEMA}
                         initialData={{ account_id: +accountId }}
                         onChange={(data) => setFormData(data as {account_id; overdraft})}/>
        <div className={`${coreStyles.button_container} ${coreStyles.full_width}`}>
            <CancelButton onClick={onClose}
                          disabled={isLoading}/>
            <Button isLoading={isLoading}
                    onClick={submitOverdraft}>
                Отправить
            </Button>
        </div>

    </Window>;
};
