import * as React from 'react';
import VirtualList from 'react-tiny-virtual-list';

import { useWindowResize } from '../../../../hooks/useWindowResize';
import { Link } from '../../../../ui/Link';
import { TSearchLinkArray } from '../types';

interface IByNameSearchResultsProps {
    searchResults: TSearchLinkArray;
}

const tableWideMargin = 270;
const tableNarrowMargin = 360;
const itemSize = 40;
const wrapWindowWidth = 1380; // at this window width 3rd search bar moves to 2nd row

export const ByNameSearchResults = (props: IByNameSearchResultsProps) => {
    const { searchResults } = props;
    const { width, height } = useWindowResize();

    return <VirtualList width={'100%'}
                        height={width > wrapWindowWidth ? height - tableWideMargin : height - tableNarrowMargin}
                        itemCount={searchResults.length}
                        itemSize={itemSize}
                        renderItem={({ index, style }) => {
                            const { link, linkText } = searchResults[index];

                            return <span key={index}
                                         style={style}>
                                <Link href={link}>{linkText}</Link>
                            </span>;
                        }}/>;
};
