import * as React from 'react';

import { Link } from '../../../../ui/Link';
import styles from './index.css';

interface ICreateWalletFromResultsProps {
    parentWalletId: string;
    addNewWallet: (parentWalletId: string) => void;
    title: string;
}

export const CreateWalletFromResults = (props: ICreateWalletFromResultsProps) => {
    const { parentWalletId, addNewWallet, title } = props;

    return <div className={styles.createWalletFromResults}>
        <Link onClick={() => {
            addNewWallet(parentWalletId);
        }}>
            {title}
        </Link>
    </div>;
};
