import * as React from 'react';

import { Dict } from '../../../../../../types';
import { UserInfoHandler } from '../../../../../models/user';
import { ActionCheckbox } from '../../../../../ui/ActionCheckbox';
import { Link } from '../../../../../ui/Link';
import { NoInformation } from '../../../../../ui/NoInformation';
import { rubs } from '../../../../../utils/rubs';
import { IAccount } from '../../../../Settings/Wallets/types';
import { PayRoadIcon } from '../../../utils/PayRoadIcon/component';
import { WalletActiveIndicator } from '../../../utils/WalletActiveIndicator/component';
import * as mainStyles from '../../index.css';
import { IWalletAccounts } from '../../types';
import { TActivateWallet, TShowRideHistoryForIds } from '../component';
import * as styles from './index.css';

interface ISearchResultsAccount {
    walletAccount?: IWalletAccounts;
    style?: React.CSSProperties;
    showRideHistoryForIds: TShowRideHistoryForIds;
    showUserLinksHistory: (accountId: number) => void;
    showBalanceHistory: (accountId: number) => void;
    setHeightFromRef?: (ref) => void;
    activateWallet: TActivateWallet;
    expandActivateError: (error: Error) => void;
    setAccountForEdit: (account: IAccount) => void;
    setAccountIdToRemove: (id: string) => void;
    blockRules?: Dict<boolean>;
}

export const SearchResultAccount = (props: ISearchResultsAccount) => {
    const {
        walletAccount,
        style,
        showRideHistoryForIds,
        showUserLinksHistory,
        setHeightFromRef,
        showBalanceHistory,
        activateWallet,
        expandActivateError,
        setAccountForEdit,
        setAccountIdToRemove,
        blockRules,
    } = props;
    const data = walletAccount?.data ?? null;
    const users = walletAccount?.users ?? [];
    //registration requests don't return id for user, only phones

    const userIds = React.useMemo(() => {
        return users?.reduce((_acc: string[], user) => {
            const userId = UserInfoHandler.getId.call(user);
            if (userId) {
                _acc.push(userId);
            }

            return _acc;
        }, []) as string[] ?? [];
    }, [users]);
    const sidebarRef = React.useRef<HTMLDivElement>(null);
    const [isActiveWallet, setActiveWallet] = React.useState(data?.is_active ?? false);
    const deleteButtonRule = blockRules?.RemoveB2B;

    React.useEffect(() => {
        setHeightFromRef?.(sidebarRef);
    }, []);

    if (!data) {
        return null;
    }

    return <div style={style}
                className={`${mainStyles.row} ${styles.searchRow}`}>
        {isActiveWallet === data?.is_active
            ? <WalletActiveIndicator isActive={data?.is_actual}/>
            : <span className={styles.isActive_text}>is_active changed</span>
        }
        <ActionCheckbox className={mainStyles.alignFromStart}
                        expandError={expandActivateError}
                        value={isActiveWallet}
                        setValue={setActiveWallet}
                        requestOnToggle={activateWallet.bind(null, !isActiveWallet, data?.id)}/>
        <span>{data?.comment} ({data?.id})</span>
        <span className={mainStyles.money}>{rubs(data?.hard_limit)}</span>
        <span className={mainStyles.money}>{rubs(data?.balance)}</span>
        <span className={mainStyles.money}>{rubs(data?.spent)}</span>
        <span>
            <PayRoadIcon enable={data?.enable_toll_road_pay}/>
        </span>
        <span>
            {users?.length
                ? users.map((user, index) => {
                    const isRegistrationRequest = !UserInfoHandler.getId.call(user)
                        && UserInfoHandler.getPhone.call(user);

                    return <span key={index}>
                        {isRegistrationRequest
                            ? <span>
                                {UserInfoHandler.getPhone.call(user)} ({UserInfoHandler.getStatus.call(user)})
                            </span>
                            : <Link href={`#/clients/${UserInfoHandler.getId.call(user)}/info`}
                                    target={'_blank'}>
                                {UserInfoHandler.getPrintName.call(user)} ({UserInfoHandler.getStatus.call(user)})
                            </Link>
                        }
                    </span>;
                })
                : <NoInformation/>
            }
        </span>
        <span className={styles.actionColumn} ref={sidebarRef}>
            <Link onClick={setAccountForEdit.bind(null, data)}
                  className={styles.searchRowLink}>
                    Редактировать
            </Link>
            {userIds?.length
                ? <Link onClick={showRideHistoryForIds.bind(null, userIds, data?.type_name)}
                        className={styles.searchRowLink}>
                        История поездок
                </Link>
                : null
            }
            <Link onClick={showUserLinksHistory.bind(null, data?.id)}
                  className={styles.searchRowLink}>
                    История привязок
            </Link>
            <Link onClick={showBalanceHistory.bind(null, data?.id)}
                  className={styles.searchRowLink}>
                    История баланса (личный лимит)
            </Link>
            {deleteButtonRule
                ? <Link onClick={setAccountIdToRemove.bind(null, data?.id)}
                        className={`${styles.deleteLink} ${styles.searchRowLink}`}>
                        Удалить
                </Link>
                : null
            }
        </span>
    </div>;

};
