import * as React from 'react';
import VirtualList from 'react-tiny-virtual-list';

import { Dict } from '../../../../../../types';
import { useVirtualListDynamicHeight } from '../../../../../hooks/useVirtualListDynamicHeight';
import { useWindowResize } from '../../../../../hooks/useWindowResize';
import * as mainStyles from '../../index.css';
import { IWalletAccounts, VIRTUALLIST_TABLE_HEIGHT } from '../../types';
import * as styles from './index.css';

interface ISearchResultsAccounts {
    walletAccounts: Dict<IWalletAccounts[]>;
    walletName?: string;
    children: React.ReactElement;
}

const ITEM_SIZE = 40;
const HEIGHT_LIMIT = 400;
//avoid unnecessary scroll
const ITEM_HEIGHT_PADDING = 5;

export const SearchResultsAccounts = (props: ISearchResultsAccounts) => {
    const {
        walletAccounts,
        walletName = '',
    } = props;
    const [rowHeights, setHeightFromRef] = useVirtualListDynamicHeight({
        defaultItemSize: ITEM_SIZE,
        initialState: new Array(walletAccounts[walletName]?.length).fill(ITEM_SIZE),
    });
    const { height } = useWindowResize();
    const maxHeight = height - HEIGHT_LIMIT;

    const tableHeight = rowHeights.reduce((a, b) => {
        if (a <= maxHeight) {
            a += b;
        }

        return a;
    }, 0) + ITEM_HEIGHT_PADDING ?? VIRTUALLIST_TABLE_HEIGHT;

    return <>
        <div className={`${mainStyles.header} ${styles.searchHeader}`}>
            <span>is_actual</span>
            <span className={mainStyles.alignFromStart}>is_active</span>
            <span>Комментарий (id)</span>
            <span className={mainStyles.money}>Hard limit</span>
            <span className={mainStyles.money}>Баланс</span>
            <span className={mainStyles.money}>Потрачено</span>
            <span className={mainStyles.money}>Оплата дорог</span>
            <span>Пользователи кошелька</span>
            <span>Действия</span>
            {tableHeight > maxHeight + ITEM_HEIGHT_PADDING && <span className={styles.scrollMargin}/>}
        </div>
        <VirtualList key={walletName}
                     width={'100%'}
                     height={tableHeight}
                     itemCount={walletAccounts[walletName]?.length}
                     itemSize={(index) => {
                         return rowHeights[index] ?? ITEM_SIZE;
                     }}
                     renderItem={({ index, style }) => {
                         const walletAccount = walletAccounts[walletName][index];
                         const childrenProps = {
                             setHeightFromRef: setHeightFromRef.bind(null, index),
                             style,
                             walletAccount,
                             key: index,
                         };

                         return React.cloneElement(props.children, childrenProps);
                     }}/>
    </>;
};
