import * as React from 'react';

import { EMPTY_DATA } from '../../../../../constants';
import { ActionCheckbox } from '../../../../../ui/ActionCheckbox';
import { Link } from '../../../../../ui/Link';
import { NoInformation } from '../../../../../ui/NoInformation';
import { IBlockRules } from '../../../../../utils/IBlockRules';
import { rubs } from '../../../../../utils/rubs';
import { IAccount } from '../../../../Settings/Wallets/types';
import { AccountTagsModal } from '../../../AccountTagsModal';
import CreateWalletFromResults from '../../CreateWalletFromResults';
import mainStyles from '../../index.css';
import { ISearchWalletsResults } from '../../types';
import { TActivateWallet } from '../component';
import styles from './index.css';

interface ISearchResultsOrganizationProps extends IBlockRules {
    seacrhResults: ISearchWalletsResults;
    organizationId: string;
    children: React.ReactElement;
    activateWallet: TActivateWallet;
    expandActivateError: (error: Error) => void;
    setOrganizationAccountForEdit: (account: IAccount) => void;
    setIdToCreateWallet: (organizationId: string) => void;
    setAccountIdOverdraft: (organizationId: string) => void;
    setOverdraftHistoryId: (organizationId: string) => void;
}

export const SearchResultsOrganization = (props: ISearchResultsOrganizationProps) => {
    const [isExpandedOrganization, expandOrganization] = React.useState(false);
    const {
        organizationId,
        expandActivateError,
        activateWallet,
        setOrganizationAccountForEdit,
        setIdToCreateWallet,
        setAccountIdOverdraft,
        setOverdraftHistoryId,
        BlockRules,
    } = props;
    const { walletLimits, organizations } = props.seacrhResults;
    const organization = organizations[organizationId];
    const overdraft = Number(organization?.details?.balance_info?.overdraft);
    const isWallet = organization?.parent;
    const [isActiveWallet, setActiveWallet] = React.useState(organization?.is_active ?? false);
    const [accountTagsModalIsOpen, showAccountTagsModal] = React.useState(false);

    React.useEffect(() => {
        expandOrganization(false);
    }, [organizationId]);

    return <div className={styles.organization}>
        <div className={styles.organizationHeader}>
            <span className={styles.leftSide}>
                <span>
                    <span>
                        <span><strong>Организация:</strong> {organization?.details?.company}</span>
                        <span className={styles.title}>— {organization?.id}</span>
                    </span>
                </span>
            </span>
            <span className={styles.rightSide}>
                {!isWallet
                    ? <span>
                        <span className={styles.title}>Овердрафт: </span>
                        <Link onClick={setOverdraftHistoryId.bind(null, organizationId)}>
                            {overdraft >= 0
                                ? rubs(overdraft)
                                : EMPTY_DATA
                            }
                        </Link>
                    </span>
                    : null}
                <span>
                    <span className={styles.title}>Баланс: </span>
                    <span>
                        {organization?.balance >= 0
                            ? rubs(organization.balance)
                            : EMPTY_DATA
                        }
                    </span>
                </span>
                <span>
                    {BlockRules?.WalletPostPay
                        && <Link onClick={setAccountIdOverdraft.bind(null, organizationId)}>
                            Установить овердрафт
                        </Link>}
                </span>
                <span>
                    <Link onClick={showAccountTagsModal.bind(null, true)}>
                        Работа с тегами
                    </Link>
                </span>
                <span>
                    <Link onClick={setOrganizationAccountForEdit.bind(null, organization)}>
                        Редактировать
                    </Link>
                </span>
                <span className={styles.activateToggle}>
                    <span>Активирован:</span>
                    <ActionCheckbox className={mainStyles.alignFromStart}
                                    expandError={expandActivateError}
                                    value={isActiveWallet}
                                    setValue={setActiveWallet.bind(null, !isActiveWallet)}
                                    requestOnToggle={activateWallet.bind(null, !isActiveWallet, organization?.id)}/>
                </span>
                <span className={styles.expandLink}
                      onClick={expandOrganization.bind(null, !isExpandedOrganization)}>
                    {isExpandedOrganization ? 'Свернуть' : 'Развернуть'}
                </span>
            </span>
        </div>
        {isExpandedOrganization && <CreateWalletFromResults parentWalletId={organizationId}
                                                            addNewWallet={setIdToCreateWallet}
                                                            title={'Добавить новый лимит'}/>}
        {walletLimits?.length ?
            isExpandedOrganization
                ? walletLimits
                    ?.filter((walletLimit) => walletLimit?.meta?.parent_id === +organizationId)
                    ?.map((walletLimit, index) => {
                        const childrenProps = {
                            walletLimit,
                            key: index,
                        };

                        return React.cloneElement(props.children, childrenProps);
                    })
                : null
            : <NoInformation className={styles.noInformation}/>
        }
        {
            accountTagsModalIsOpen
            && <AccountTagsModal organization={organization}
                                 onClose={showAccountTagsModal.bind(null, false)}/>
        }
    </div>;
};
