import * as React from 'react';

import { ErrorsModal } from '../../../../ui/ErrorBar';
import { Request2 } from '../../../../utils/request';
import { AccountAddModal } from '../../../Settings/Wallets/AccountAddModal';
import { AccountDetailsModal } from '../../../Settings/Wallets/AccountDetailsModal';
import { AccountRemoveModal } from '../../../Settings/Wallets/AccountRemoveModal';
import { IAccount } from '../../../Settings/Wallets/types';
import { WalletAddModal } from '../../../Settings/Wallets/WalletAddModal';
import { REQUESTS } from '../../request';
import { BalanceHistory } from '../BalanceHistory/component';
import BalanceOverdraft from '../BalanceOverdraft';
import OverdraftHistory from '../OverdraftHistory';
import RidesHistory from '../RidesHistory';
import { ISearchWalletsResults } from '../types';
import UserLinksHistory from '../UserLinksHistory';
import WalletsHistory from '../WalletsHistory';
import SearchResultAccount from './SearchResultAccount';
import SearchResultsAccounts from './SearchResultsAccounts';
import SearchResultsOrganization from './SearchResultsOrganization';
import SearchResultsWalletLimit from './SearchResultsWalletLimit';

interface IWalletsSearchResults {
    searchResults: ISearchWalletsResults;
    request: Request2;
}

export type TShowRideHistoryForIds = (userIds: string[], activeAccountName: string) => void;
export type TActivateWallet = (isActive: boolean, accountId: number) => Promise<unknown>

export const WalletsSearchResults = (props: IWalletsSearchResults) => {
    const { walletAccounts, organizations = {} } = props.searchResults;
    const { request } = props;
    const [userIds, setUserIds] = React.useState<string[] | null>(null);
    const [balanceAccountId, setBalanceAccountId] = React.useState<number | null>(null);
    const [walletsHistoryAccountId, setWalletsHistoryAccountId] = React.useState<number | null>(null);
    const [userLinksAccountId, setUserLinksAccountId] = React.useState<number | null>(null);
    const [activeAccountName, setActiveAccountName] = React.useState<string | null>(null);
    const [activateError, expandActivateError] = React.useState<Error | null>(null);
    const [editWalletName, setWalletNameForEdit] = React.useState<string | null>(null);
    const [idToCreateWallet, setIdToCreateWallet] = React.useState<string | null>(null);
    const [idToCreateAccount, setIdToCreateAccount] = React.useState<string | null>(null);
    const [editAccount, setAccountForEdit] = React.useState<IAccount | null>(null);
    const [editedOnPage, setEditedOnPage] = React.useState<boolean>(false);
    const [accountIdToRemove, setAccountIdToRemove] = React.useState<string | null>(null);
    const [accountIdOverdraft, setAccountIdOverdraft] = React.useState<string | null>(null);
    const [overdraftHistoryId, setOverdraftHistoryId] = React.useState<string | null>(null);
    const [filteredWalletAccounts, setFilteredWalletAccounts] = React.useState(walletAccounts);

    const showRideHistoryForIds = (userIds: string[], activeAccountName: string) => {
        setUserIds(userIds);
        setActiveAccountName(activeAccountName);
    };

    const activateWallet: TActivateWallet = async (isActive: boolean, accountId: number): Promise<unknown> => {
        return await request.exec(REQUESTS.ACTIVATE_ACCOUNT, {
            body: {
                account_id: accountId,
                active_flag: isActive,
            },
        });
    };

    React.useEffect(() => {
        if (editedOnPage) {
            location.reload();
        }
    }, [editedOnPage]);

    return <>
        {Array.isArray(userIds) && activeAccountName && <RidesHistory accountName={activeAccountName}
                                                                      request={request}
                                                                      onClose={showRideHistoryForIds.bind(null, null)}
                                                                      userIds={userIds}/>}
        {accountIdOverdraft && <BalanceOverdraft onClose={setAccountIdOverdraft.bind(null, null)}
                                                 accountId={accountIdOverdraft}
                                                 request={request}/>}
        {activateError && <ErrorsModal errors={[activateError]}
                                       onClose={expandActivateError.bind(null, null)}/>}
        {balanceAccountId
            ? <BalanceHistory request={request}
                              accountId={balanceAccountId.toString()}
                              onClose={setBalanceAccountId.bind(null, null)}/>
            : null
        }
        {walletsHistoryAccountId
            ? <WalletsHistory request={request}
                              accountId={walletsHistoryAccountId.toString()}
                              onClose={setWalletsHistoryAccountId.bind(null, null)}/>
            : null
        }
        {overdraftHistoryId
            ? <OverdraftHistory request={request}
                                accountId={overdraftHistoryId.toString()}
                                onClose={setOverdraftHistoryId.bind(null, null)}/>
            : null
        }
        {userLinksAccountId
            ? <UserLinksHistory request={request}
                                accountId={userLinksAccountId.toString()}
                                onClose={setUserLinksAccountId.bind(null, null)}/>
            : null
        }
        {editWalletName || idToCreateWallet
            ? <WalletAddModal onClose={() => {
                if (editWalletName) {
                    setWalletNameForEdit(null);
                }

                if (idToCreateWallet) {
                    setIdToCreateWallet(null);
                }
            }}
                              onCloseAfterSave={() => {
                                  setEditedOnPage(true);
                              }}
                              parentId={idToCreateWallet ?? undefined}
                              walletName={editWalletName ?? undefined}
                              title={idToCreateWallet ? 'Создать кошелек' : 'Редактировать кошелек'}/>
            : null
        }
        {idToCreateAccount
            ? <AccountAddModal accountName={idToCreateAccount}
                               onClose={() => {
                                   setIdToCreateAccount(null);
                               }}
                               reloadData={setEditedOnPage.bind(null, true)}/>
            : null
        }
        {accountIdToRemove && <AccountRemoveModal accountId={accountIdToRemove}
                                                  onClose={() => {
                                                      setAccountIdToRemove(null);
                                                  }}
                                                  reloadData={setEditedOnPage.bind(null, true)}/>}
        {editAccount
            ? <AccountDetailsModal account={editAccount}
                                   onClose={() => {
                                       setAccountForEdit(null);
                                   }}
                                   reloadData={setEditedOnPage.bind(null, true)}/>
            : null
        }
        {Object.keys(organizations)?.map((organizationId, index) => {
            return <SearchResultsOrganization key={index}
                                              seacrhResults={props.searchResults}
                                              organizationId={organizationId}
                                              activateWallet={activateWallet}
                                              expandActivateError={expandActivateError}
                                              setOrganizationAccountForEdit={setAccountForEdit}
                                              setIdToCreateWallet={setIdToCreateWallet}
                                              setOverdraftHistoryId={setOverdraftHistoryId}
                                              setAccountIdOverdraft={setAccountIdOverdraft}>
                <SearchResultsWalletLimit showRideHistoryForIds={showRideHistoryForIds}
                                          showWalletBalanceHistory={setBalanceAccountId}
                                          showWalletsHistory={setWalletsHistoryAccountId}
                                          walletAccounts={walletAccounts}
                                          setFilteredWalletAccounts={setFilteredWalletAccounts}
                                          setWalletNameForEdit={setWalletNameForEdit}
                                          setIdToCreateAccount={setIdToCreateAccount}>
                    <SearchResultsAccounts walletAccounts={filteredWalletAccounts}>
                        <SearchResultAccount setAccountForEdit={setAccountForEdit}
                                             showRideHistoryForIds={showRideHistoryForIds}
                                             showUserLinksHistory={setUserLinksAccountId}
                                             expandActivateError={expandActivateError}
                                             showBalanceHistory={setBalanceAccountId}
                                             activateWallet={activateWallet}
                                             setAccountIdToRemove={setAccountIdToRemove}/>
                    </SearchResultsAccounts>
                </SearchResultsWalletLimit>
            </SearchResultsOrganization>;
        })}
    </>;
};
