import * as React from 'react';

import { Input } from '../../../../ui/Input';
import { SEARCH_ID_TYPE, SEARCH_NAME_TYPE } from '../types';
import * as styles from './index.css';

interface IWalletsSearchBarProps {
    searchId: string;
    onChangeSearch: (expectedSearchIdType: SEARCH_ID_TYPE | SEARCH_NAME_TYPE, value: string) => void;
    showOr?: boolean;
    searchIdType: SEARCH_ID_TYPE | SEARCH_NAME_TYPE | null;
    expectedSearchIdType: SEARCH_ID_TYPE | SEARCH_NAME_TYPE;
}

const PLACEHOLDER_SEARCH_BAR = {
    [SEARCH_ID_TYPE.WALLET_LIMIT_ID]: 'Название лимита',
    [SEARCH_ID_TYPE.ORGANIZATION_ID]: 'ID организации',
    [SEARCH_NAME_TYPE.ORGANIZATION_NAME]: 'Название организации [в ограниченном режиме]',
};

export const WalletsSearchBar = (props: IWalletsSearchBarProps) => {
    const {
        searchId,
        onChangeSearch,
        showOr = false,
        expectedSearchIdType,
        searchIdType,
    } = props;

    return <div className={styles.searchBar}>
        <Input value={expectedSearchIdType === searchIdType ? searchId : ''}
               placeholder={PLACEHOLDER_SEARCH_BAR[expectedSearchIdType]}
               onChange={(value) => onChangeSearch(expectedSearchIdType, value.trim())}/>
        {showOr && <div className={styles.showOr}>или</div>}
    </div>;
};
